/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.io;

import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.io.CharsWrapper;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.io.ParsingException;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.io.Utils;

public interface CharacterInput {
    public int read();

    public char readChar();

    default public int readAndSkip(char[] toSkip) {
        int c;
        while ((c = this.read()) != -1 && Utils.arrayContains(toSkip, (char)c)) {
        }
        return c;
    }

    default public char readCharAndSkip(char[] toSkip) {
        char c;
        while (Utils.arrayContains(toSkip, c = this.readChar())) {
        }
        return c;
    }

    default public CharsWrapper read(int n) {
        int next;
        CharsWrapper.Builder builder = new CharsWrapper.Builder(n);
        for (int i2 = 0; i2 < n && (next = this.read()) != -1; ++i2) {
            builder.append((char)next);
        }
        return builder.build();
    }

    default public CharsWrapper readChars(int n) {
        char[] chars = new char[n];
        for (int i2 = 0; i2 < n; ++i2) {
            int next = this.read();
            if (next == -1) {
                throw ParsingException.notEnoughData();
            }
            chars[i2] = (char)next;
        }
        return new CharsWrapper(chars);
    }

    public CharsWrapper readUntil(char[] var1);

    public CharsWrapper readCharsUntil(char[] var1);

    public int peek();

    public int peek(int var1);

    public char peekChar();

    public char peekChar(int var1);

    public void skipPeeks();

    public void pushBack(char var1);
}

